/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.dialogs;

import com.aptana.core.CoreStrings;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.ide.core.io.ConnectionPointUtils;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.io.LocalConnectionPoint;
import com.aptana.ide.ui.io.IOUIPlugin;
import com.aptana.ide.ui.io.dialogs.Messages;
import com.aptana.ui.IPropertyDialog;
import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LocalConnectionPropertyDialog
extends TitleAreaDialog
implements IPropertyDialog {
    private static final String DEFAULT_NAME = Messages.LocalConnectionPropertyDialog_NewShortcut;
    private LocalConnectionPoint localConnectionPoint;
    private boolean isNew = false;
    private Text nameText;
    private Text localPathText;
    private Button browseButton;
    private Image titleImage;
    private ModifyListener modifyListener;

    public LocalConnectionPropertyDialog(Shell parentShell) {
        super(parentShell);
    }

    public void setPropertySource(Object element) {
        this.localConnectionPoint = null;
        if (element instanceof LocalConnectionPoint) {
            this.localConnectionPoint = (LocalConnectionPoint)element;
        }
    }

    public Object getPropertySource() {
        return this.localConnectionPoint;
    }

    private String getConnectionPointType() {
        return "local";
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.titleImage = IOUIPlugin.getImageDescriptor("/icons/full/wizban/local.png").createImage();
        dialogArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (LocalConnectionPropertyDialog.this.titleImage != null) {
                    LocalConnectionPropertyDialog.this.setTitleImage(null);
                    LocalConnectionPropertyDialog.this.titleImage.dispose();
                    LocalConnectionPropertyDialog.this.titleImage = null;
                }
            }
        });
        this.setTitleImage(this.titleImage);
        if (this.localConnectionPoint != null) {
            this.setTitle(Messages.LocalConnectionPropertyDialog_EditTitle);
            this.getShell().setText(Messages.LocalConnectionPropertyDialog_EditText);
        } else {
            this.setTitle(Messages.LocalConnectionPropertyDialog_CreateTitle);
            this.getShell().setText(Messages.LocalConnectionPropertyDialog_CreateText);
        }
        Composite container = new Composite(dialogArea, 0);
        container.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        container.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(this.convertHorizontalDLUsToPixels(7), this.convertVerticalDLUsToPixels(7)).spacing(this.convertHorizontalDLUsToPixels(4), this.convertVerticalDLUsToPixels(4)).numColumns(3).create());
        Label label = new Label(container, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(55), -1).create());
        label.setText(StringUtil.makeFormLabel((String)Messages.LocalConnectionPropertyDialog_ShortcutName));
        this.nameText = new Text(container, 2052);
        this.nameText.setLayoutData((Object)GridDataFactory.fillDefaults().hint(this.convertHorizontalDLUsToPixels(200), -1).span(2, 1).grab(true, false).create());
        label = new Label(container, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(55), -1).create());
        label.setText(StringUtil.makeFormLabel((String)Messages.LocalConnectionPropertyDialog_LocalPath));
        this.localPathText = new Text(container, 2052);
        this.localPathText.setLayoutData((Object)GridDataFactory.swtDefaults().hint(this.convertHorizontalDLUsToPixels(200), -1).grab(true, false).create());
        this.browseButton = new Button(container, 8);
        this.browseButton.setText(String.valueOf('&') + StringUtil.ellipsify((String)CoreStrings.BROWSE));
        this.browseButton.setLayoutData((Object)GridDataFactory.fillDefaults().hint(Math.max(new PixelConverter((Control)this.browseButton).convertHorizontalDLUsToPixels(61), this.browseButton.computeSize((int)-1, (int)-1, (boolean)true).x), -1).create());
        this.addListeners();
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalConnectionPropertyDialog.this.browseFileSystem();
            }
        });
        if (this.localConnectionPoint == null) {
            try {
                this.localConnectionPoint = (LocalConnectionPoint)CoreIOPlugin.getConnectionPointManager().createConnectionPoint(this.getConnectionPointType());
                this.localConnectionPoint.setName(DEFAULT_NAME);
                this.isNew = true;
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)IOUIPlugin.getDefault(), (String)Messages.LocalConnectionPropertyDialog_FailedToCreate, (Throwable)e);
                this.close();
            }
        }
        this.loadPropertiesFrom(this.localConnectionPoint);
        return dialogArea;
    }

    protected void addListeners() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    LocalConnectionPropertyDialog.this.validate();
                }
            };
        }
        this.nameText.addModifyListener(this.modifyListener);
        this.localPathText.addModifyListener(this.modifyListener);
    }

    protected void removeListeners() {
        if (this.modifyListener != null) {
            this.nameText.removeModifyListener(this.modifyListener);
            this.localPathText.removeModifyListener(this.modifyListener);
        }
    }

    protected void okPressed() {
        if (!this.isValid()) {
            return;
        }
        if (this.savePropertiesTo(this.localConnectionPoint)) {
            this.localConnectionPoint.hashCode();
        }
        if (this.isNew) {
            CoreIOPlugin.getConnectionPointManager().addConnectionPoint((IConnectionPoint)this.localConnectionPoint);
        }
        super.okPressed();
    }

    protected Control createContents(Composite parent) {
        try {
            Control control = super.createContents(parent);
            return control;
        }
        finally {
            this.validate();
        }
    }

    protected void loadPropertiesFrom(LocalConnectionPoint connectionPoint) {
        this.removeListeners();
        try {
            this.nameText.setText(LocalConnectionPropertyDialog.valueOrEmpty(connectionPoint.getName()));
            IPath path = connectionPoint.getPath();
            this.localPathText.setText(path != null ? path.toPortableString() : "");
        }
        finally {
            this.addListeners();
        }
    }

    protected boolean savePropertiesTo(LocalConnectionPoint connectionPoint) {
        IPath path;
        boolean updated = false;
        String name = this.nameText.getText();
        if (!name.equals(connectionPoint.getName())) {
            connectionPoint.setName(name);
            updated = true;
        }
        if (!(path = Path.fromPortableString((String)this.localPathText.getText())).equals((Object)connectionPoint.getPath())) {
            connectionPoint.setPath(path);
            updated = true;
        }
        return updated;
    }

    private void browseFileSystem() {
        DirectoryDialog dlg = new DirectoryDialog(this.getShell());
        dlg.setFilterPath(this.localPathText.getText());
        String path = dlg.open();
        if (path != null) {
            this.localPathText.setText(Path.fromOSString((String)path).toPortableString());
            if (DEFAULT_NAME.equals(this.nameText.getText())) {
                this.nameText.setText(Path.fromOSString((String)path).lastSegment());
            }
        }
    }

    public void validate() {
        boolean valid = this.isValid();
        this.getButton(0).setEnabled(valid);
    }

    public boolean isValid() {
        String message = null;
        String name = this.nameText.getText().trim();
        if (name.length() == 0) {
            message = Messages.LocalConnectionPropertyDialog_SpecifyShortcutName;
        } else if (!(this.localConnectionPoint != null && name.equals(this.localConnectionPoint.getName()) || ConnectionPointUtils.isConnectionPointNameUnique((String)name))) {
            message = MessageFormat.format(Messages.LocalConnectionPropertyDialog_DuplicateShortcutName, name);
        } else {
            File file = Path.fromPortableString((String)this.localPathText.getText()).toFile();
            if (!file.exists() || !file.isDirectory()) {
                message = Messages.LocalConnectionPropertyDialog_LocationNotExist;
            }
        }
        if (message == null) {
            this.setErrorMessage(null);
            this.setMessage(null);
            return true;
        }
        this.setErrorMessage(message);
        return false;
    }

    protected static String valueOrEmpty(String value) {
        if (value != null) {
            return value;
        }
        return "";
    }
}

